//Circuit RC automatique sur un cycle de decharge
//Prof-TC Fevrier 2025

// ---------- Initialisation ---------------------
int etat = 0;
// 0 au début
// 1 pendant la charge
// 2 pendant la décharge
// 3 quand c'est fini

long previousMillis = 0;   // Initialisation du temps
long interval = 50;   // nombre de millisecondes entre chaque mesure
float topdepart = 0;  //on initialise un variable topdepart à 0
float tension;   //variable tension qui sera lue
unsigned long toptension = 0;   //On initialise la tension

void setup() {   
  pinMode(8, OUTPUT);     // alimentation du condensateur
  Serial.begin(9600);     //vitesse de communication avec arduino
  tension = analogRead(A0);     // on lit la tension sur la sortie analogique A0
  //Serial.println(F("temps,tension")); 


// dans un premier temps, on s'assure que le condensateur est completement déchargé
  Serial.println("Preparation du condensateur");
  while (tension > 1) {
      digitalWrite(8, LOW);                                               
      delay(500);                                                           
      tension = analogRead(A0);   // on lit la tension sur la sortie analogique A0 toutes les 500 ms
    }
  //digitalWrite(8,LOW);
  delay(2000);

// nouvel etat:  charge du condensateur
  etat = 1;
  Serial.println("Charge du condensateur");
  delay(2000);
  topdepart = millis();   //on donne le topdepart
  toptension = analogRead(A0)*5.0/1024;   //on donne le zero de la tension
  digitalWrite(8,HIGH);   // on met en marche l'alimentation
}


void loop() {

  unsigned long currentMillis = millis();
  int tension;
    
// il est temps de prendre une nouvelle mesure
  if(currentMillis - previousMillis >= interval) {
    previousMillis = currentMillis;
    
// charge du condensateur
    if (etat == 1) {
      tension = analogRead(A0);
      // pas completement charge
      
      if (tension < 1020){     
      }
      // completement charge
      
      else{
        // on change d'état:  décharge du condensateur
        etat = 2;
        Serial.println("Decharge du condensateur");
        Serial.print("t (s)");
        Serial.print("\t");
        Serial.println("U (V)"); 
        // désactivation de l'alimentation
        digitalWrite(8,LOW);
      }
      topdepart = millis();   //on donne le topdepart
    }


// décharge du condensateur
    if (etat == 2) {
      tension = analogRead(A0);
      // pas completement décharge
      
      if (tension > 0){
        // Valeur et conversion en volt
        Serial.print((currentMillis - topdepart)/1000);
        Serial.print("\t");
        //Serial.print(F(","));
        Serial.println(tension*5.0/1024);
      }

      // completement déchargé
      else {
        // on change d'état:  tout est terminé
        etat = 3;
      }
    }
    
  }


}
